import SearchBox, { searchColumns } from '~/components/search-box';
import { Button, Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { PlusOutlined } from '@ant-design/icons';
import { useNavigate } from 'react-router-dom';

const InstitutionsList = () => {
  const navigate = useNavigate();
  const search: searchColumns[] = [
    { label: '机构名称', name: '', placeholder: '请输入机构名称', type: 'input' },
    { label: '培训类型', name: '', placeholder: '请选择培训类型', type: 'select', options: [] },
    { label: '选择日期', name: '', placeholder: '请选择日期', type: 'rangePicker', options: [] },
  ];
  const tableColumns: ColumnsType<any> = [
    {
      title: '序号',
      align: 'center',
    },
    {
      title: '机构名称',
      align: 'center',
    },
    {
      title: '培训类型',
      align: 'center',
    },
    {
      title: '创建日期',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
    },
  ];
  const toAddInstitutions = () => {
    navigate('/pilotTraining/institutionsList/add');
  };
  return (
    <div className='institutions-list'>
      <SearchBox
        search={search}
        child={
          <Button icon={<PlusOutlined />} type='primary' onClick={toAddInstitutions}>
            新增
          </Button>
        }
      />
      <Table bordered columns={tableColumns} />
    </div>
  );
};
export default InstitutionsList;
